/**
 * @param { import("knex").Knex } knex
 * @returns { Promise<void> }
 */
exports.up = function(knex) {
  return knex.schema.createTable("games",(table)=>{
    table.increments('id').primary();
    table.string('name').nullable();
    table.text('description');
    table.string('thumbnail').nullable();
    table.string('bannerImage').nullable();
    table.string('logo').nullable();
    table.string('link').nullable();
    table.integer('like').defaultTo(0);
    table.string('category').nullable();
    table.timestamp("createdAt").nullable();
    table.timestamp("expiresAt").nullable();
  })
};

/**
 * @param { import("knex").Knex } knex
 * @returns { Promise<void> }
 */
exports.down = function(knex) {
  return knex.schema.dropTable("games");
};
